/*
 * Decompiled with CFR 0.152.
 */
package ResetThosePacks;

import ResetThosePacks.BCrypt;

public class BcryptTest {
    private static int workload = 10;

    public static String hashPassword(String password_plaintext) {
        String salt = BCrypt.gensalt();
        String hashed_password = BCrypt.hashpw(password_plaintext, salt);
        return hashed_password;
    }

    public static boolean checkPassword(String password_plaintext, String stored_hash) {
        boolean password_verified = false;
        if (stored_hash == null || !stored_hash.startsWith("$2y$")) {
            throw new IllegalArgumentException("Invalid hash provided for comparison");
        }
        password_verified = BCrypt.checkpw(password_plaintext, stored_hash);
        return password_verified;
    }

    public static void main(String[] args) {
        String test_passwd = "admin";
        String test_hash = "$2y$10$qHsRVLMar167hJEKmKrZgu.FDQXgJCcw9RRoAMwfzYU3..E.XzVfe";
        System.out.println("Testing BCrypt Password hashing and verification");
        System.out.println("Test password: " + test_passwd);
        System.out.println("Test stored hash: " + test_hash);
        System.out.println("Hashing test password...");
        System.out.println();
        String computed_hash = BcryptTest.hashPassword(test_passwd);
        System.out.println("Test computed hash: " + computed_hash);
        System.out.println();
        System.out.println("Verifying that hash and stored hash both match for the test password...");
        System.out.println();
        String compare_test = BcryptTest.checkPassword(test_passwd, test_hash) ? "Passwords Match" : "Passwords do not match";
        String compare_computed = BcryptTest.checkPassword(test_passwd, computed_hash) ? "Passwords Match" : "Passwords do not match";
        System.out.println("Verify against stored hash:   " + compare_test);
        System.out.println("Verify against computed hash: " + compare_computed);
    }
}

